/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.fddi;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionFddiPort
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.fddi.eui.EnumeratedResources";
    private static String fddiBundle = "ibm.nways.fddi.Resources";
    private boolean loggingOn = false;

    public ActionFddiPort() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionFddiPort");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        int n2 = (Integer)serializableArray[1];
        if (this.loggingOn) {
            System.out.println("newConnectState = " + statusModelInfo.get("Panel.FddimibPORTConnectState"));
        }
        Integer n3 = (Integer)statusModelInfo.get("Panel.FddimibPORTConnectState");
        int n4 = n3;
        StatusAndExplain statusAndExplain = this.evaluatePortConnect(n4, n, n2);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFDDIPort - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(fddiBundle, "STATUS_TABLE_PORT");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFddiPort - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(fddiBundle, "STATUS_NAME_PORT", objectArray);
        return i18NMsgFormat;
    }

    private StatusAndExplain evaluatePortConnect(int n, int n2, int n3) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n2), new Integer(n3)};
        objectArray[0] = new I18NMsgFormat(fddiBundle, "portstatus", objectArray2);
        if (n == 1) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.fddi.model.PortModel.Panel.FddimibPORTConnectState.disabled");
        } else if (n == 2) {
            statusAndExplain.statType = StatusType.MARGINAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.fddi.model.PortModel.Panel.FddimibPORTConnectState.connecting");
        } else if (n == 3) {
            statusAndExplain.statType = StatusType.MARGINAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.fddi.model.PortModel.Panel.FddimibPORTConnectState.standby");
        } else if (n == 4) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.fddi.model.PortModel.Panel.FddimibPORTConnectState.active");
        } else {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray[1] = new I18NString(enumBundle, "unknown");
        }
        statusAndExplain.explain = new I18NGiblets(fddiBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("statType = " + statusAndExplain.statType);
            System.out.println("explain  = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionFddiPort.this = ActionFddiPort.this;
        }
    }
}

